#include "dep3.h"

struct _MesonDep3
{
  GObject parent_instance;

  gchar *msg;
};

G_DEFINE_TYPE (MesonDep3, meson_dep3, G_TYPE_OBJECT)

enum {
  PROP_0,
  PROP_MSG,
  LAST_PROP
};

static GParamSpec *gParamSpecs [LAST_PROP];

/**
 * meson_dep3_new:
 * @msg: The message to set.
 *
 * Allocates a new #MesonDep3.
 *
 * Returns: (transfer full): a #MesonDep3.
 */
MesonDep3 *
meson_dep3_new (const gchar *msg)
{
  g_return_val_if_fail (msg != NULL, NULL);

  return g_object_new (MESON_TYPE_DEP3,
                       "message", msg,
                       NULL);
}

static void
meson_dep3_finalize (GObject *object)
{
  MesonDep3 *self = (MesonDep3 *)object;

  g_clear_pointer (&self->msg, g_free);

  G_OBJECT_CLASS (meson_dep3_parent_class)->finalize (object);
}

static void
meson_dep3_get_property (GObject    *object,
                           guint       prop_id,
                           GValue     *value,
                           GParamSpec *pspec)
{
  MesonDep3 *self = MESON_DEP3 (object);

  switch (prop_id)
    {
    case PROP_MSG:
      g_value_set_string (value, self->msg);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
meson_dep3_set_property (GObject      *object,
                           guint         prop_id,
                           const GValue *value,
                           GParamSpec   *pspec)
{
  MesonDep3 *self = MESON_DEP3 (object);

  switch (prop_id)
    {
    case PROP_MSG:
      self->msg = g_value_dup_string (value);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
meson_dep3_class_init (MesonDep3Class *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  object_class->finalize = meson_dep3_finalize;
  object_class->get_property = meson_dep3_get_property;
  object_class->set_property = meson_dep3_set_property;

  gParamSpecs [PROP_MSG] =
    g_param_spec_string ("message",
                         "Message",
                         "The message to print.",
                         NULL,
                         (G_PARAM_READWRITE |
                          G_PARAM_CONSTRUCT_ONLY |
                          G_PARAM_STATIC_STRINGS));

  g_object_class_install_properties (object_class, LAST_PROP, gParamSpecs);
}

static void
meson_dep3_init (MesonDep3 *self)
{
}

/**
 * meson_dep3_return_message:
 * @self: a #MesonDep3.
 *
 * Returns the message.
 *
 * Returns: (transfer none): a const gchar*
 */
const gchar*
meson_dep3_return_message (MesonDep3 *self)
{
  g_return_val_if_fail (MESON_IS_DEP3 (self), NULL);

  return (const gchar*) self->msg;
}
